var timerInterval = null;

var minutesAngle;
var hoursAngle;

var minhand = new Image (200, 200);
minhand.src = 'Images/minute.pdf';

var hourhand = new Image (200, 200);
hourhand.src = 'Images/hour.pdf';

//var secondhand = new Image (200, 200);
//secondhand.src = 'Images/second.pdf';

function updateTime()
{
	var now = new Date();
	var img = document.getElementById("clock-image");


	secondsAngle = now.getSeconds() * 0.10471975511965977;
	
	minutesAngle = now.getMinutes() * 0.10471975511965977;
	//minutesAngle = 15 * 0.10471975511965977;
	hoursAngle = ((now.getHours()%12) * 0.523598775598) + (minutesAngle/6.283185481853 * 0.523598775598);
	//hoursAngle = ((6%12) * 0.523598775598) + (minutesAngle/6.283185481853 * 0.523598775598);

	drawHands(hoursAngle, minutesAngle, secondsAngle);
	timerInterval = setInterval("updateTime();", 20000);
}

function clearHands()
{
	var canvas =    document.getElementById("canvas");
	var context = canvas.getContext("2d");
	
	context.clearRect (0, 0, 400, 400);
}

function drawHands (hoursAngle, minutesAngle, secondsAngle)
{
	var canvas =    document.getElementById("canvas");
	var context = canvas.getContext("2d");
	
	context.restore();
	context.clearRect (0, 0, 400, 400);

	context.save();
	
	context.translate (200, 200);
	
	// Hour hand
	context.save();
	context.rotate (hoursAngle);
	context.translate (-40, -35);
	context.drawImage (hourhand, 0, 0, 80, 200);
	context.restore();
	
	// Minute hand
	context.save();
	context.rotate (minutesAngle);
	context.translate (-40, -35);
	context.drawImage (minhand, 0, 0, 80, 200);
	context.restore();
	
	// Second hand
	//context.rotate (secondsAngle);
	//context.translate (-40, -35);
	//context.drawImage (secondhand, 0, 0, 80, 200);
	//context.restore();	
}


function onshow () {
	updateTime();
}

function onhide () {
	if (timerInterval != null) {
		clearHands();
		clearInterval(timerInterval);
		timerInterval = null;
	}
}

function showbackside(event)
{
	var front = document.getElementById("front");
	var back = document.getElementById("behind");
	
	if (window.widget)
		widget.prepareForTransition("ToBack");
	onhide();
	
	front.style.display="none";
	back.style.display="block";
	
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);	


	document.getElementById('fliprollie').style.display = 'none';
}


function doneClicked() {
        var front = document.getElementById("front");
        var back = document.getElementById("behind");

        if (window.widget)
                widget.prepareForTransition("ToFront");


        front.style.display="block";
        back.style.display="none";

        setTimeout ('flipitback();', 0);
        onshow();

}


function flipitback()
{
	updateTime(false);
	if (window.widget)
		setTimeout("widget.performTransition();", 0);
}


if (window.widget) {
	data = widget.preferenceForKey("locale");
	widget.onhide = onhide;
	widget.onshow = onshow;
}




if (window.widget){

}

function enterflip(event)
{
	document.getElementById('fliprollie').style.display = 'block';
}

function exitflip(event)
{
	document.getElementById('fliprollie').style.display = 'none';
}

function debug(msg) {
	if (!debug.box) {
		debug.box = document.createElement("div");
		debug.box.setAttribute("style", "background-color: white; " +
										"font-family: monospace; " +
										"border: solid black 3px; " +
										"position: absolute;top:300px;" +
										"padding: 10px;");
		document.body.appendChild(debug.box);
		debug.box.innerHTML = "<h1 style='text-align:center'>Debug Output</h1>";
	}
	
	var p = document.createElement("p");
	p.appendChild(document.createTextNode(msg));
	debug.box.appendChild(p);
}
